CREATE SCHEMA IF NOT EXISTS yang;

CREATE TABLE IF NOT EXISTS yang.assignment (
    assignment_id text PRIMARY KEY,
    pool_id bigint NOT NULL,
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),
    input_lang text,
    input_meta text,
    input_country text,
    input_coordinates text,
    output_object_kind text,
    output_object_photos text,
    output_object_comment text,
    output_object_coordinates text,
    output_worker_coordinates text,
    output_worker_manual_coordinates text,
    golden_object_kind text,
    golden_object_comment text,
    golden_object_coordinates text,
    golden_worker_coordinates text,
    golden_worker_manual_coordinates text,
    hint_text text,
    hint_default_language text,
    assignment_link text,
    assignment_assignment_id text,
    assignment_worker_id text,
    assignment_status text,
    assignment_started text
);

CREATE INDEX IF NOT EXISTS assignment_pool_id_idx
    ON yang.assignment USING btree (pool_id);

CREATE TABLE IF NOT EXISTS yang.assignment_photo (
    assignment_id text REFERENCES yang.assignment(assignment_id) NOT NULL,
    attachment_id text NOT NULL,
    photo_id text NOT NULL UNIQUE,
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),

    PRIMARY KEY (assignment_id, attachment_id)
);
