CREATE MATERIALIZED VIEW IF NOT EXISTS social.feedback_aoi_oldest_opened_task_data_mv AS (
    WITH aoi_feedback_full AS (
        SELECT
            aoi.aoi_id,
            fb.id,
            fb.created_at,
            fb.type,
            fb.attrs,
            fb.source,
            fb.workflow
        FROM social.feedback_aoi_feed_outgoing_opened aoi
        JOIN social.feedback_task_outgoing_opened fb ON aoi.feedback_task_id = fb.id
        WHERE fb.bucket = 'outgoing'
    )
    SELECT af_oldest.aoi_id,
        af_oldest.source,
        af_oldest.type,
        af_oldest.workflow,
        af_oldest.min_created_at,
        af.id,
        row_number() OVER (PARTITION BY af_oldest.aoi_id, af_oldest.source, af_oldest.type, af_oldest.workflow) AS row_id
    FROM (
        SELECT
            aoi_feedback_full.aoi_id,
            aoi_feedback_full.source,
            aoi_feedback_full.type,
            aoi_feedback_full.workflow,
            min(aoi_feedback_full.created_at) AS min_created_at
        FROM aoi_feedback_full
        GROUP BY aoi_feedback_full.aoi_id, aoi_feedback_full.source, aoi_feedback_full.type, aoi_feedback_full.workflow
    ) af_oldest
    JOIN aoi_feedback_full af ON af_oldest.aoi_id = af.aoi_id AND af_oldest.source = af.source AND af_oldest.type = af.type
     AND af_oldest.workflow = af.workflow AND af_oldest.min_created_at = af.created_at
) WITH DATA;

DROP MATERIALIZED VIEW social.feedback_aoi_oldest_opened_task_mv;
CREATE MATERIALIZED VIEW social.feedback_aoi_oldest_opened_task_mv AS (
    SELECT * FROM social.feedback_aoi_oldest_opened_task_data_mv
    WHERE row_id=1
) WITH DATA;

CREATE UNIQUE INDEX feedback_aoi_oldest_opened_task_mv_idx
    ON social.feedback_aoi_oldest_opened_task_mv
    USING btree (aoi_id, source, type, workflow, min_created_at, id);


CREATE MATERIALIZED VIEW IF NOT EXISTS social.feedback_aoi_opened_task_stat_data_mv AS (
    SELECT
        aoi.aoi_id,
        fb.source,
        fb.type,
        fb.workflow,
        count(*) AS total,
        count(*) FILTER (WHERE fb.hidden = true) AS total_hidden,
        count(*) FILTER (WHERE fb.workflow = 'feedback' AND fb.created_at <= (now() - '24:00:00'::interval)) AS old,
        count(*) FILTER (WHERE fb.workflow = 'feedback' AND fb.created_at <= (now() - '24:00:00'::interval) AND fb.hidden = true) AS old_hidden
    FROM social.feedback_aoi_feed_outgoing_opened aoi
    JOIN social.feedback_task_outgoing_opened fb ON aoi.feedback_task_id = fb.id
    WHERE fb.duplicate_head_id IS NULL AND fb.bucket = 'outgoing'
    GROUP BY aoi.aoi_id, fb.source, fb.type, fb.workflow
) WITH DATA;

DROP MATERIALIZED VIEW social.feedback_aoi_opened_task_stat_mv;
CREATE MATERIALIZED VIEW social.feedback_aoi_opened_task_stat_mv AS (
    SELECT * FROM social.feedback_aoi_opened_task_stat_data_mv
) WITH DATA;

CREATE UNIQUE INDEX feedback_aoi_opened_task_stat_mv_idx
    ON social.feedback_aoi_opened_task_stat_mv
    USING btree (aoi_id, source, type, workflow, total, total_hidden, old, old_hidden);
