CREATE SCHEMA IF NOT EXISTS toloka;

CREATE TYPE toloka.task_status_type AS ENUM (
    'processing',
    'ok',
    'failed'
);

CREATE TYPE toloka.task_type AS ENUM (
    'entrance'
);

CREATE TABLE IF NOT EXISTS toloka.tasks (
    pool_id bigint NOT NULL,
    assignment_id text NOT NULL,
    task_type toloka.task_type NOT NULL,
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),
    data jsonb NOT NULL,
    status toloka.task_status_type NOT NULL,

    PRIMARY KEY (pool_id, assignment_id)
);

CREATE INDEX IF NOT EXISTS tasks_task_type_status_idx
    ON toloka.tasks
    USING btree (task_type, status);


CREATE TABLE IF NOT EXISTS toloka.photos (
    pool_id bigint NOT NULL,
    assignment_id text NOT NULL,
    attachment_id text NOT NULL,
    photo_id text NOT NULL UNIQUE,
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),

    PRIMARY KEY (pool_id, assignment_id, attachment_id),

    CONSTRAINT photos_pool_id_assignment_id_fkey
        FOREIGN KEY (pool_id, assignment_id)
        REFERENCES toloka.tasks(pool_id, assignment_id)
        ON UPDATE NO ACTION ON DELETE CASCADE
);
