CREATE TYPE sprav.photo_data_subject_type AS ENUM (
    'entrance',
    'facade'
);

CREATE TYPE sprav.company_bundle_state AS ENUM (
    'draft',
    'waiting',
    'submitted',
    'canceled',
    'failed'
);

CREATE TABLE IF NOT EXISTS sprav.photo_data (
    photo_id text PRIMARY KEY UNIQUE,
    shooting_point geometry(POINT, 3395) NOT NULL,
    shooting_target geometry(POINT, 3395) NOT NULL,
    subject sprav.photo_data_subject_type NOT NULL
);

CREATE TABLE IF NOT EXISTS sprav.company_bundle (
    bundle_id bigserial PRIMARY KEY,
    permalink_id bigint NOT NULL,
    altay_poi_position geometry(POINT, 3395) NOT NULL,
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),
    bundle_state sprav.company_bundle_state NOT NULL DEFAULT 'draft',
    submitted_at timestamp with time zone,
    feedback_task_id bigint
);

CREATE INDEX IF NOT EXISTS sprav_company_bundle_permalink ON sprav.company_bundle
USING btree(permalink_id);

CREATE TABLE IF NOT EXISTS sprav.company_bundle_photo (
    bundle_id bigint REFERENCES sprav.company_bundle (bundle_id),
    photo_id text REFERENCES sprav.photo_data (photo_id)
);

CREATE INDEX IF NOT EXISTS sprav_company_bundle_photo_bundle_id ON sprav.company_bundle_photo
USING btree(bundle_id);

CREATE INDEX IF NOT EXISTS sprav_company_bundle_photo_photo_id ON sprav.company_bundle_photo
USING btree(photo_id);
