#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>

namespace maps::wiki::aclsrv {

void checkAclPermissions(acl::UID uid, acl::Transaction& work, FromTest fromTest = FromTest::False);
void checkAclAssignPermissions(acl::UID uid, acl::Transaction& work);
void checkBanPermissions(acl::UID uid, acl::Transaction& work);
void checkBanable(const acl::ACLGateway& aclgw, const acl::User& user);
void checkAccessToGroups(acl::UID uid, acl::Transaction& work);
void checkAccessToRoles(acl::UID uid, acl::Transaction& work);
void checkAccessToUsers(acl::UID uid, acl::Transaction& work);

bool hasAccessToPermisions(acl::UID uid, acl::Transaction& work);
bool hasAccessToAssign(acl::UID uid, acl::Transaction& work);

struct CanAssign
{
    enum class Any {
        True,
        False
    };
    Any any = Any::False;
    std::set<acl::ID> roleIds;
    std::set<acl::ID> groupIds;
    acl::UID uid;
};

CanAssign getUserCanAssign(acl::UID authorUid, acl::Transaction& work);

} // namespace maps::wiki::aclsrv
