#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/wikimap/mapspro/libs/acl/include/common.h>
#include <maps/libs/common/include/enum_bitset.h>
#include <maps/libs/json/include/value.h>

#include <optional>

namespace maps::wiki::aclsrv {

enum class FromTest {
    True,
    False
};

enum class IsYandexRequest {
    Yes,
    No
};

enum class OutputFlags : unsigned
{
    None = 0,
    Minimal = None,
    WithPolicies,
    WithPermissions = WithPolicies,
    WithModerationStatus,
    WithBanInfo,
    WithBanableInfo,
    WithYandex,
    WithOutsourcer,
    WithPieceworker,
    EnumBitsetFlagsEnd
};

using OutputFlagsSet = maps::common::EnumBitset<OutputFlags>;
const OutputFlagsSet OutputAll {
    OutputFlags::WithPolicies,
    OutputFlags::WithModerationStatus,
    OutputFlags::WithBanInfo,
    OutputFlags::WithBanableInfo,
    OutputFlags::WithYandex,
    OutputFlags::WithOutsourcer,
    OutputFlags::WithPieceworker,
};

std::string outputPermissionId(const std::string& dbPermissionId);
std::string dbPermissionId(const std::string& outputPermissionId);

struct ScheduleData
{
    std::string startDate;
    std::optional<std::string> endDate;
    std::optional<std::string> startTime;
    std::optional<std::string> endTime;
    std::optional<int> weekdays;
    std::optional<std::string> workRestDays;
};

struct PolicyData
{
    acl::ID roleId;
    acl::ID aoiId;
    std::optional<ScheduleData> schedule;
};

struct GroupData
{
    acl::ID id;
    std::string name;
    std::optional<ScheduleData> schedule;
};

struct PolicyWithGroup {
    std::optional<acl::Role> role;
    std::optional<acl::Aoi> aoi;
    std::optional<acl::Group> group;
    acl::Schedules schedules;
};

enum class IsNew {
    True,
    False
};

enum class ChangedPermissions {
    True,
    False
};

std::vector<ScheduleData>
parseSchedules(const json::Value& schedulesJson);

bool
equal(
    const ScheduleData& scheduleData,
    const acl::Schedule& schedule);

bool
equal(
    const acl::ScheduledPolicy& scheduledPolicy,
    const acl::Policy& policy);

bool
equal(
    const PolicyData& data,
    const acl::Policy& policy);

bool
equal(
    const PolicyData& data,
    const acl::ScheduledPolicy& scheduledPolicy);

bool
equal(
    const GroupData& data,
    const acl::Group& group);

bool
equal(
    const GroupData& data,
    const acl::ScheduledGroup& scheduledGroup);

std::vector<acl::ScheduledPolicy>::const_iterator
find(
    const std::vector<acl::ScheduledPolicy>& scheduledPolicies,
    const acl::Policy& policy);

template<typename T>
std::vector<PolicyData>
remove(
    std::vector<PolicyData> policiesData,
    const T& policy)
{
    policiesData.erase(
        std::remove_if(
            policiesData.begin(),
            policiesData.end(),
            [&](const auto& policyData) {
                return equal(policyData, policy);
            }),
        policiesData.end());
    return policiesData;
}

template<typename T>
std::vector<GroupData>
remove(
    std::vector<GroupData> groupsData,
    const T& group)
{
    groupsData.erase(
        std::remove_if(
            groupsData.begin(),
            groupsData.end(),
            [&](const auto& groupData) {
                return equal(groupData, group);
            }),
        groupsData.end());
    return groupsData;
}

using CombinedScheduledPolicies = std::map<std::pair<acl::ID, acl::ID>, std::vector<acl::Schedule>>;
using CombinedScheduledGroups = std::map<acl::ID, std::vector<acl::Schedule>>;

struct CombinedScheduledObjects
{
    CombinedScheduledPolicies policies;
    CombinedScheduledGroups groups;
};

CombinedScheduledObjects
combineScheduledObjects(const acl::ScheduledObjects& scheduledObjects);

} // namespace maps::wiki::aclsrv
