#include "config.h"

#include <memory>

namespace maps::wiki::aclsrv {

namespace {

const std::string ACL_CONFIG_LOCATION = "/config/services/acl/config-dir";
const std::string ACL_ALLOW_DELETE_USER_CONFIG_PATH = "/config/services/acl/allow-delete-user";
const std::string ACL_ENABLE_IDM_CHECK_CONFIG_PATH = "/config/services/acl/enable-idm-check";
const std::string ACL_PERMISSIONS_XML = "permissions.xml";
const std::string LOG_LEVEL_CONFIG_LOCATION = "/config/log/level";
const std::string DEFAULT_LOG_LEVEL = "info";

std::unique_ptr<Config> s_cfg_;

} // namespace

Config::Config(const std::string& filename)
    : doc_(filename)
    , permissionsLabelsTree_(get<std::string>(ACL_CONFIG_LOCATION) + ACL_PERMISSIONS_XML)
{
    logLevel_ = get<std::string>(LOG_LEVEL_CONFIG_LOCATION, DEFAULT_LOG_LEVEL);
    allowDeleteUser_ =
        get<bool>(ACL_ALLOW_DELETE_USER_CONFIG_PATH, false)
        ? AllowDeleteUser::Yes
        : AllowDeleteUser::No;
    enableIdmCheck_ =
        get<bool>(ACL_ENABLE_IDM_CHECK_CONFIG_PATH, true)
        ? EnableIdmCheck::Yes
        : EnableIdmCheck::No;
}

ConfigScope::ConfigScope(const std::string& fileName)
{
    s_cfg_.reset(new Config(fileName));
}
ConfigScope::~ConfigScope()
{
    s_cfg_.reset();
}

Config* cfg()
{
    ASSERT(s_cfg_);
    return s_cfg_.get();
}

} // namespace maps::wiki::aclsrv
