#pragma once

#include "permissions_labels_tree.h"
#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <list>

namespace maps::wiki::aclsrv {

class Config
{
public:
    enum class AllowDeleteUser {
        Yes,
        No
    };

    enum class EnableIdmCheck {
        Yes,
        No
    };
    explicit Config(const std::string& fileName);

    template <class ResultType>
    ResultType get(const std::string& path) const
    { return doc_.get<ResultType>(path); }

    /**
     * @returns value of element by XPath
     */
    template <class ResultType>
    ResultType get(const std::string& path, const ResultType& default_value) const
    { return doc_.get<ResultType>(path, default_value); }

    const std::string& logLevel() const { return logLevel_; }

    const std::string& permissionLabel(
        const std::string& id,
        const std::list<std::string>& path) const
    { return permissionsLabelsTree_.findLabel(id, path); }

    bool allowDeleteUser() const { return allowDeleteUser_ == AllowDeleteUser::Yes; }
    bool enableIdmCheck() const { return enableIdmCheck_ == EnableIdmCheck::Yes; }

private:
    maps::wiki::common::ExtendedXmlDoc doc_;
    std::string logLevel_;
    PermissionsLabelsTree permissionsLabelsTree_;
    AllowDeleteUser allowDeleteUser_;
    EnableIdmCheck enableIdmCheck_;
};

Config* cfg();

class ConfigScope
{
public:
    explicit ConfigScope(const std::string& filename);
    ~ConfigScope();
};

} // namespace maps::wiki::aclsrv
