#pragma once

#include "common.h"
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <memory>
#include <string>

namespace maps::wiki::aclsrv {

class ConnectionManager
{
public:
    ConnectionManager(const std::string& filepath, const std::string& srvName);

    ~ConnectionManager();

    static maps::pgpool3::TransactionHandle slaveTransaction(const std::string& token);

    static maps::pgpool3::TransactionHandle masterWriteableTransaction(acl::UID authorUid);

private:
    static std::unique_ptr<common::PoolHolder> s_poolHolder;

};

} // namespace maps::wiki::aclsrv
