#pragma once

#include "common.h"
#include <maps/infra/yacare/include/error.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace yacare {

class Request;

} // namespace yacare

namespace maps::wiki::aclsrv {

class Error : public yacare::Error
{
public:
    enum class Status {
        UserAlreadyExists,
        RoleAlreadyExists,
        GroupAlreadyExists,
        UserNotExists,
        RoleNotExists,
        GroupNotExists,
        Forbidden,
    };

    explicit Error(Status);
    ~Error() {};
    virtual void raise() const { throw *this; }
    virtual void format(yacare::Response&) const;
    Status status() const { return status_; }

private:
    Status status_;
};

DECLARE_ENUM_IO(Error::Status);

void errorReporter(const yacare::Request&, yacare::Response&);

} // namespace maps::wiki::aclsrv
