#pragma once

#include "common.h"
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/libs/json/include/builder.h>

namespace acl = maps::wiki::acl;

namespace maps::wiki::aclsrv {

void write(
    json::ArrayBuilder arrayBuilder,
    acl::ACLGateway& aclGw,
    const acl::User& user,
    IsYandexRequest isYandexRequest,
    OutputFlagsSet outputFlags,
    const std::string& modStatus);

void write(
    json::VariantBuilder variantBuilder,
    acl::ACLGateway& aclGw,
    const acl::User& user,
    IsYandexRequest isYandexRequest,
    OutputFlagsSet outputFlags,
    const std::string& modStatus);

void write(
    json::ArrayBuilder arrayBuilder,
    const acl::BanRecord& banRecord);

void write(
    json::VariantBuilder variantBuilder,
    const acl::BanRecord& banRecord);

void write(
    json::Builder& jsonBuilder,
    const acl::Permissions& allPermissions);

void write(
    json::Builder& jsonBuilder,
    const acl::Permissions& allPermissions,
    const std::vector<acl::Permission>& permissions);

void write(
    json::VariantBuilder variantBuilder,
    const acl::Permissions& allPermissions,
    const std::vector<acl::Permission>& permissions);

void write(
    json::Builder& jsonBuilder,
    acl::ACLGateway& aclGw,
    const acl::Permissions& allPermissions,
    const acl::Role& role);

void write(
    json::ArrayBuilder arrayBuilder,
    acl::ACLGateway& aclGw,
    const acl::Permissions& allPermissions,
    const acl::Role& role);

void write(
    json::Builder& jsonBuilder,
    acl::ACLGateway& aclGw,
    const acl::Permissions& allPermissions,
    const acl::ResultBeforeAfter<acl::Role>& rolesResult);

enum class CompleteResult {
    True,
    False
};

void write(
    json::Builder& jsonBuilder,
    const std::vector<PolicyWithGroup>& policiesWithGroups,
    CompleteResult completeResult);

void write(
    json::Builder& jsonBuilder,
    acl::ACLGateway& aclGw,
    const acl::Group& group,
    OutputFlagsSet outputFlags);

void write(
    json::ArrayBuilder arrayBuilder,
    acl::ACLGateway& aclGw,
    const acl::Group& group,
    OutputFlagsSet outputFlags);

void write(
    json::Builder& jsonBuilder,
    acl::ACLGateway& aclGw,
    const acl::ResultBeforeAfter<acl::Group>& groupsResult,
    OutputFlagsSet outputFlags);

void write(
    json::ObjectBuilder jsonBuilder,
    const common::Pager& pager);

void write(
    json::ArrayBuilder arrayBuilder,
    const std::vector<acl::Role>& roles);

void write(
    json::ArrayBuilder arrayBuilder,
    acl::ACLGateway& aclGw,
    const std::vector<acl::Group>& groups);

} // namespace maps::wiki::aclsrv
