#include "moderation_status.h"

#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <yandex/maps/wiki/common/moderation.h>

namespace maps::wiki::aclsrv {

namespace {

// Ordered by descending significance
const std::vector<std::string> MODERATION_STATUSES = {
    common::MODERATION_STATUS_ROBOT,
    common::MODERATION_STATUS_CARTOGRAPHER,
    common::MODERATION_STATUS_YANDEX_MODERATOR,
    common::MODERATION_STATUS_MODERATOR,
    common::MODERATION_STATUS_EXPERT,
    common::MODERATION_STATUS_COMMON
};

} // namespace

std::string
moderationStatus(
    const acl::ACLGateway& aclgw,
    const acl::User& user)
{
    return aclgw.firstApplicableRole(
        user,
        MODERATION_STATUSES,
        common::MODERATION_STATUS_COMMON);
}

std::map<acl::ID, std::string>
moderationStatuses(
    const acl::ACLGateway& aclgw,
    const std::vector<acl::User>& users)
{
    return aclgw.firstApplicableRoles(
        users,
        MODERATION_STATUSES,
        common::MODERATION_STATUS_COMMON);
}

} // namespace maps::wiki::aclsrv
