#include "permissions_labels_tree.h"

#include <memory>

namespace maps::wiki::aclsrv {

namespace {

const std::string s_emptyString;
const std::string PERMISSION_NODE = "permission";
const std::string LABEL_NODE = "label";
const std::string ID_ATTR = "id";

} // namespace

PermissionsLabelsTree::Node::Node(const maps::xml3::Node& node)
{
    auto labelNode = node.firstElementChild(LABEL_NODE);
    if (!labelNode.isNull()) {
        label_ = labelNode.value<std::string>();
    }
    auto childNode = node.firstElementChild(PERMISSION_NODE);
    while (!childNode.isNull()) {
        auto childNodeId = childNode.attr<std::string>(ID_ATTR);
        childrenById_.insert(std::make_pair(
            childNodeId, std::unique_ptr<Node>(new Node(childNode))));
        childNode = childNode.nextElementSibling(PERMISSION_NODE);
    }
}

const std::string&
PermissionsLabelsTree::findLabel(const std::string& id, const std::list<std::string>& path) const
{
    const auto* level = &root_.childrenById_;
    for (const auto& nodeId : path) {
        auto it = level->find(nodeId);
        if (it == level->end()) {
            return s_emptyString;
        }
        level = &it->second->childrenById_;
    }
    auto it = level->find(id);
    return it == level->end()
        ? s_emptyString
        : it->second->label_;
}

} // namespace maps::wiki::aclsrv
