#pragma once

#include <maps/libs/xml/include/xml.h>

#include <list>
#include <memory>
#include <unordered_map>

namespace maps::wiki::aclsrv {

class PermissionsLabelsTree
{
public:
    explicit PermissionsLabelsTree(const std::string& permissionsXml)
        : root_(maps::xml3::Doc(permissionsXml).root())
    {}

    const std::string& findLabel(
        const std::string& id,
        const std::list<std::string>& path) const;

private:
    struct Node
    {
    public:
        explicit Node(const maps::xml3::Node& node);

        std::string label_;
        std::unordered_map<std::string, std::unique_ptr<Node>> childrenById_;
    };

    Node root_;
};

} // namespace maps::wiki::aclsrv
