#pragma once

#include "common.h"
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>

#include <vector>

namespace maps::wiki::aclsrv {

using Sequence = std::vector<bool>;

std::vector<Sequence>
generateBinarySequences(size_t maxLength);

bool
leftBinSeqContainsRight(
    const Sequence& leftSequence,
    const Sequence& rightSequence);

struct PermittingPolicies
{
    std::vector<PolicyWithGroup> policies;
    bool complete = true;
};

PermittingPolicies
calculatePermittingPolicies(
    acl::ACLGateway gw,
    const std::vector<PolicyWithGroup>& userPolicies,
    const std::vector<acl::SubjectPath>& permissionPaths);

} // namespace maps::wiki::aclsrv
