#pragma once

#include "common.h"
#include "json_writer.h"
#include <maps/infra/yacare/include/yacare.h>

namespace maps::wiki::aclsrv {

class JsonResponseWrapper
{
public:
    JsonResponseWrapper(yacare::Response& response)
        :jsonBuilder_(response)
    {
        response["Content-Type"] = "application/json";
    }
    maps::json::Builder& jsonBuilder()
    {
        return jsonBuilder_;
    }

private:
    maps::json::Builder jsonBuilder_;
};

} // namespace maps::wiki::aclsrv
