#pragma once

#include "common.h"
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/libs/json/include/value.h>

#include <string>
#include <vector>

namespace maps::wiki::aclsrv {

class GroupUpdateData
{
public:
    explicit GroupUpdateData(const json::Value& jsonGroupObject);

    static std::vector<GroupUpdateData> parseData(const std::string& str);
    acl::ID id() const { return id_; }
    const std::optional<std::string>& name() const { return name_; }
    const std::optional<std::vector<PolicyData>>& policies() const { return policies_; }
    const std::optional<std::string>& description() const { return description_; }

private:
    acl::ID id_;
    std::optional<std::string> name_;
    std::optional<std::vector<PolicyData>> policies_;
    std::optional<std::string> description_;
};

struct SaveGroupResult
{
    acl::Group group;
    IsNew isNew;
    ChangedPermissions changedPermissions = ChangedPermissions::False;
};

std::vector<SaveGroupResult> saveGroups(
    acl::ACLGateway& gw,
    const std::string& str,
    acl::UID authorUid);

void checkDeleteGroupAccess(const acl::Group& group, acl::UID authorUid, acl::Transaction& work);

} // namespace maps::wiki::aclsrv
