#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/libs/json/include/value.h>

#include <string>
#include <vector>
#include <unordered_set>

namespace maps::wiki::aclsrv {

struct RoleData {
    acl::ID id = 0;
    std::optional<std::string> name;
    std::optional<std::string> description;
    std::optional<acl::Role::Privacy> privacy;
    std::optional<std::vector<acl::SubjectPath>> permissionPaths;
    std::optional<std::unordered_set<acl::ID>> canAssignRolesIds;
    std::optional<std::unordered_set<acl::ID>> canAssignGroupsIds;

    explicit RoleData(const json::Value& jsonRoleObject);
};

struct RoleSaveResult
{
    acl::Role role;
    IsNew isNew;
    ChangedPermissions changedPermissions = ChangedPermissions::False;
};

RoleSaveResult saveRole(
    acl::ACLGateway& gw,
    const acl::Permissions& allPermissions,
    const RoleData& roleData,
    acl::UID authorUid);

std::vector<acl::SubjectPath> extractPermissions(
    const json::Value& jsonPermissionsObject);

} // namespace maps::wiki::aclsrv
