#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/moderation.h>
#include <yandex/maps/wiki/common/moderation.h>

#include <optional>

namespace maps::wiki::aclsrv {

class UserInfo
{
public:
    UserInfo(const acl::User& user, std::string moderationStatus)
        : user_(user)
        , moderationStatus_(std::move(moderationStatus))
    {}

    bool isOutsourcer()
    {
        if (!isOutsourcerCachedValue_) {
            isOutsourcerCachedValue_ = acl_utils::isOutsourcer(allPolicies());
        }
        return *isOutsourcerCachedValue_;
    }

    bool isPieceworker()
    {
        return acl_utils::isPieceworker(allPolicies());
    }

    bool isYandex()
    {
        if (moderationStatus_ != common::MODERATION_STATUS_CARTOGRAPHER &&
            moderationStatus_ != common::MODERATION_STATUS_YANDEX_MODERATOR)
        {
            return false;
        }
        return !isOutsourcer();
    }

    bool isBanable()
    {
        if (moderationStatus_ != common::MODERATION_STATUS_EXPERT &&
            moderationStatus_ != common::MODERATION_STATUS_COMMON)
        {
            return false;
        }
        return !isOutsourcer();
    }

private:
    const std::vector<acl::Policy>& allPolicies()
    {
        if (!allPolicies_) {
            allPolicies_ = user_.allPolicies();
        }
        return *allPolicies_;
    }

    const acl::User& user_;
    const std::string moderationStatus_;

    std::optional<std::vector<acl::Policy>> allPolicies_;
    std::optional<bool> isOutsourcerCachedValue_;
};

} // namespace maps::wiki::aclsrv
