#pragma once

#include <opencv2/opencv.hpp>

#include <memory>
#include <utility>

namespace maps::wiki {

namespace tf_inferencer {

class TensorFlowInferencer;

} // namespace tf_inferencer

namespace autocart {

class AutoToloker {
public:
    AutoToloker();

    ~AutoToloker();

    // return probability of good building
    float classify(const cv::Mat& imageBGR, const cv::Mat& mask) const;

private:
    size_t yesAnswerIndex_;

    std::unique_ptr<tf_inferencer::TensorFlowInferencer> classifier_;
};

} // namespace autocart

} // namespace maps::wiki
