#pragma once
#include <maps/wikimap/mapspro/libs/tf_inferencer/tf_inferencer.h>
#include <maps/wikimap/mapspro/libs/tf_inferencer/maskrcnn_inferencer.h>
#include <maps/libs/geolib/include/bounding_box.h>

#include <opencv2/opencv.hpp>

#include <vector>

namespace maps {
namespace wiki {
namespace autocart {

// Разбиваем прямоугольник на батчи
std::vector<std::vector<std::pair<int, int>>> makeCropBatches(
    int horizCellsCnt, int vertCellsCnt,
    size_t batchSize);

// Result of Mask RCNN
struct BldInstance {
    BldInstance(const geolib3::BoundingBox& bbox,
                const cv::Mat& mask)
        : bbox(bbox),
          mask(mask) {

    }
    // Bouding box for instance
    geolib3::BoundingBox bbox;
    // Mask for instance. Mask have same size as bounding box
    cv::Mat mask;
};

/**
 * @brief Segments different building instances on image of any size:
 *     Using Mask R-CNN for instance segmentation:
 *     https://arxiv.org/abs/1703.06870
 *     1) Segments overlapping image patches
 *     2) Merge building instances from different patches
 * @param maskrcnn  - path to Mask R-CNN tensorflow model in protobuf format
 * @param image     - satellite image in BGR format
 * @param batchSize - processing batchSize images at one time
 * @return bounding boxes and masks for different building instances on image
 */
std::vector<BldInstance>
segmentInstances(const tf_inferencer::MaskRCNNInferencer& maskrcnn,
                 const cv::Mat& imageBGR,
                 size_t batchSize = 1);

/**
 * @brief Merges instances from different patches.
 *     Two instances describe one building if:
 *     1) Number of common pixels is greater than some value
 *     2) IoU is greater than some value
 *     3) Number of common pixels is greater than some percentage
 *        of pixels of one of two buildings
 * @param instances - result of instance segmentation for set of image patches
 * @return merged building instances
 */
std::vector<BldInstance> mergeInstances(std::vector<BldInstance> instances);

/**
 * @brief Constructs polygons for building instances.
 * @param instances - result of instance segmentation
 * @return boundary points for each building instance
 */
std::vector<std::vector<cv::Point2f>>
vectorizeInstances(const std::vector<BldInstance>& instances);

} // namespace autocart
} // namespace wiki
} // namespace maps
