#pragma once

#include "opencv2/core/core.hpp"
#include <vector>

namespace maps {
namespace wiki {
namespace autocart {

// если явно не указано обратное, то
//     все угловые параметры в радианах
//     все длины в пикселях
struct PPPolygonsParams
{
    PPPolygonsParams()
        : nearStraightMaxDelta(45. * CV_PI / 180)
        , smallEdgesMaxDist(10.)
        , rectifyQuadToRectByEdge(false)
        , rectifyAnglesToOrthoMaxDelta(15. / 180. * CV_PI)
        , removeAcuteAngleMax(45. / 180. * CV_PI)
        , thinRectMinFraction(0.2)
        , thinRectMinLength(15.)
    {}

    // спрямляем угол (удаляем вершину) который отличается от развёрнутого
    // меньше чем на nearStraightMaxDelta
    double nearStraightMaxDelta;
    // если ребро меньше smallEdgesMaxDist, то добавляем в середину ребра вершину,
    // а само ребро удаляем
    double smallEdgesMaxDist;
    // если true, то превращаем четырехугольник в прямоугольник, зафиксировав самое
    // длинное ребро
    // если false, то фиксируем более длинное ребро из вершины угол при которой
    // ближе всех к прямому
    bool rectifyQuadToRectByEdge;
    // "выпрямляем" углы отличающиеся от прямого на угол меньше чем rectifyAnglesToOrthoMaxDelta
    double rectifyAnglesToOrthoMaxDelta;
    // удаляем углы меньшие removeAcuteAngleMax
    double removeAcuteAngleMax;
    // удаляем прямоугольники у которых отношение сторон (меньшей к большей) меньше
    // thinRectMinFraction и при этом меньшая сторона меньше thinRectMinLength
    double thinRectMinFraction;
    double thinRectMinLength;
};

void postprocessPolygons(const PPPolygonsParams &params, std::vector<std::vector<cv::Point> > &polygons);
} //namespace autocart
} //namespace wiki
} //namespace maps
