#pragma once

#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/multipolygon.h>

#include <string>

namespace maps::wiki::autocart {

/**
 * @brief Преобразует закодированную строку в WKB формате
 *     в набор полигонов.
 *     Описание WKB и WKT форматов:
 *     https://en.wikipedia.org/wiki/Well-known_text
 * @param str  закодированная строка в WKB формате
 * @return набор полигонов, полученный из данной строки
 */
geolib3::MultiPolygon2 hexWKBToMultiPolygon(std::string_view hexWKB);

/**
 * @brief Преобразует набор полигонов в закодированную строку
 *     в WKB формате.
 * @param multipolygons набор полигонов для преобразования
 * @return закодированная строка в WKB формате
 */
std::string multiPolygonToHexWKB(const geolib3::MultiPolygon2& multipolygon);

/**
 * @brief Преобразует закодированную строку в WKB формате
 *     в полигон.
 * @param hexWKB  закодированная строка в WKB формате
 * @return полигон
 */
geolib3::Polygon2 hexWKBToPolygon(std::string_view hexWKB);

/**
 * @brief Преобразует полигон в закодированную строку
 *     в WKB формате.
 * @param polygon  полигон для преобразования
 * @return закодированная строка в WKB формате
 */
std::string polygonToHexWKB(const geolib3::Polygon2& polygon);

/**
 * @brief Преобразует закодированную строку в WKB формате
 *     в полилинию.
 * @param hexWKB  закодированная строка в WKB формате
 * @return полигон
 */
geolib3::Polyline2 hexWKBToPolyline(std::string_view hexWKB);

/**
 * @brief Преобразует полилинию в закодированную строку
 *     в WKB формате.
 * @param polygon  полигон для преобразования
 * @return закодированная строка в WKB формате
 */
std::string polylineToHexWKB(const geolib3::Polyline2& polyline);


} // namespace maps::wiki::autocart
