#pragma once
#include <maps/libs/common/include/pimpl_utils.h>
#include <maps/libs/geolib/include/polygon.h>

#include <cmath>

namespace maps {
namespace wiki {
namespace autocart {

/**
 * @brief Aligns angles of the polygon if they differ from pi*n/2 less than snapPrecision
 *
 * @param polygon  polygon whose angles need to be aligned
 * @snapPrecision  Angle in radians. The algorithm tries to align angles,
 *                 which differ from pi*n/2 less than snapPrecision
 *
 * @return         polygon with aligned angles
 */
geolib3::Polygon2 alignAngles(const geolib3::Polygon2& polygon,
                              float snapPrecision = M_PI/15.0f);

class Edge {
public:
    Edge(const geolib3::Point2&, const geolib3::Point2&);
    float getAngle() const;
    void setAngle(float);
    geolib3::Point2 getPoint() const;
    bool isCollinearWith(const Edge&) const;
    geolib3::Point2 getIntersectionPoint(const Edge& edge) const;
private:
    geolib3::Point2 pt_;
    float angle_;
};

/**
 * @brief Tries to rotate all edges except the edge with index equal to fixedEdgeIndex.
 *        Begins to rotate edges from the edge with index fromVertexIndex
 *
 * @param fixedEdgeIndex  index of edge whose angle does not change
 * @param fromVertexIndex index of edge from which the aligment begins
 * @param edges           edges which need to be aligned
 * @snapPrecision         Angle in radians. The algorithm tries to align angles,
 *                        which differ from pi*n/2 less than snapPrecision
 *
 * @return                edges with aligned angles
 */
std::vector<Edge> doAlignAngles(int fixedEdgeIndex, int fromVertexIndex,
                                const std::vector<Edge>& edges,
                                float snapPrecision);

} //namespace autocart
} //namespace wiki
} //namespace maps
