#include <maps/wikimap/mapspro/services/autocart/libs/utils/include/pool.h>

namespace maps::wiki::autocart {

ThreadPool::ThreadPool(size_t threadsCount)
    : pool_(CreateThreadPool(threadsCount))
    , exceptionPtr_(nullptr)
{
}

ThreadPool::~ThreadPool() {
    Wait();
}

void ThreadPool::Wait() {
    pool_->Stop();
    if (exceptionPtr_) {
        std::exception_ptr tmpPtr = exceptionPtr_;
        exceptionPtr_ = nullptr;
        std::rethrow_exception(tmpPtr);
    }
}

} // maps::wiki::autocart
