#pragma once
#include <util/thread/pool.h>

#include <mutex>
#include <exception>
#include <stdexcept>

namespace maps::wiki::autocart {

class ThreadPool {
public:
    ThreadPool(size_t threadsCount);

    ~ThreadPool();

    template <class Func>
    void Add(Func&& func) {
        pool_->SafeAdd(MakeThrFuncObj([=]() {
            try {
                func();
            } catch (...) {
                std::lock_guard<std::mutex> lock{exceptionGuard_};
                exceptionPtr_ = std::current_exception();
            }
        }));
    }

    void Wait();

private:
    THolder<IThreadPool> pool_;
    std::mutex exceptionGuard_;
    std::exception_ptr exceptionPtr_;
};

} // maps::wiki::autocart
