# Автоматический процесс распознавания и валидации зданий

[blocks](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/autocart/pipeline/blocks "blocks")

Код для кубиков в Нирване

[cfg](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/autocart/pipeline/cfg "cfg")

Конфигурационные файлы процесса: детектора, валидации в толоке и асессорами и т.д.

[initialize](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/autocart/pipeline/initialize "initialize")

Создает хранилище в YT

[libs](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/autocart/pipeline/libs "libs")

Библиотеки для детектирования, работы с YT, Hitman, Толокой и т.д.

[toloka_templates](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/autocart/pipeline/toloka_templates "toloka_templates")

Шаблоны для заданий в Толоке

## Проект в Хитмане

[Ссылка на проект в Хитмане](https://hitman.yandex-team.ru/projects/domovoi "Проект в Хитмане")

Процессы запускаются с помощью системы Хитман.

Каждый процесс связан с одним графом в Толоке.


### Детектирование зданий

[Ссылка на процесс в Хитмане](https://hitman.yandex-team.ru/projects/domovoi/domovoi_detection "Детектирование зданий")

Процесс, проверяющий необходимость детектирования зданий и запускающий процесс, создающий тикет с результатами

Начать детектирование необходимо если:
1) Появилась новая необработанная зона в MPRO
2) Обновились спутниковые снимки на ранее обработанной территории

### Создание тикета

[Ссылка на процесс в Хитмане](https://hitman.yandex-team.ru/projects/domovoi/domovoi_create_st_issue "Создание тикета")

Создает тикет в Трекере с результатами детектирования и запускает процессы валидации

Запускаемые процессы:
1) Если необходима валидация толокерами, то запускаем "domovoi_load_tolokers_tasks"
2) Если необходима только валидация асессорами, то запускаем "domovoi_load_assessors_tasks"
3) Если валидации не нужны, то запускаем "domovoi_nmaps_publication"

### Загрузка заданий толокерам

[Ссылка на процесс в Хитмане](https://hitman.yandex-team.ru/projects/domovoi/domovoi_load_tolokers_tasks "Загрузка заданий толокерам")

Посылает в тикет запрос на валидацию зданий в толоке и ожидает перевода тикета в статус "В работе".
После перевода тикета в нужный статус загружает задания в Толоку (toloka.yandex.ru) и запускает процесс с валидацией "domovoi_tolokers_validation"

### Валидация в Толоке

[Ссылка на процесс в Хитмане](https://hitman.yandex-team.ru/projects/domovoi/domovoi_tolokers_validation "Валидации в Толоке")

Запускает валидацию зданий в Толоке. Открывает на выполнение пул, который был создан в процессе "domovoi_load_tolokers_tasks".
После окончания валидации загружает результаты в YT хранилище и отправляет в тикет комментарий с результатом.

В зависимости от параметров зоны MPRO запускает один из следующих процессов:
1) Если необходима валидация асессорами, то запускаем "domovoi_load_assessors_tasks"
2) Если валидация не нужна, то запускаем "domovoi_nmaps_publication"

### Загрузка заданий асессорам

[Ссылка на процесс в Хитмане](https://hitman.yandex-team.ru/projects/domovoi/domovoi_load_assessors_tasks "Загрузка заданий асессорам")

Посылает в тикет запрос на валидацию зданий асессорами и ожидает перевода тикета в статус "В работе".
После перевода тикета в нужный статус загружает задания для асессоров в sandbox Толоку (sandbox.toloka.yandex.ru) и запускает процесс с валидацией "domovoi_assessors_validation"

### Валидация асессорами

[Ссылка на процесс в Хитмане](https://hitman.yandex-team.ru/projects/domovoi/domovoi_assessors_validation "Валидация асессорами")

Запускает валидацию зданий в sandbox Толоке. Открывает на выполнение пул, который был создан в процессе "domovoi_load_assessors_tasks"
После окончания валидации загружает результаты в YT хранилище и отправляет в тикет комментарий с результатами.

Запускает процесс с загрузкой зданий в Народную Карту "domovoi_nmaps_publication"

### Публикация зданий

[Ссылка на процесс в Хитмане](https://hitman.yandex-team.ru/projects/domovoi/domovoi_nmaps_publication "Публикация зданий")

Отправляет в тикет запрос на публикацию зданий на карту и ожидает перевода в статус "В работе"
После перевода тикета в нужный статус загружает здания на карту и сохраняет результат в YT хранилище
Обновляет обработанный релиз в YT хранилище

### Получение отчета по асессорам

[Ссылка на процесс в Хитмане](https://hitman.yandex-team.ru/projects/domovoi/domovoi_get_bld_assessors_report_to_mail "Получение отчета по асессорам")

По запросу из Яндекс.Формы выкачивает из Толоки статистку по выполненным заданиям и качестве ответы на контрольные задания.
Отправляет сформированный csv файл на почту пользователя, который его запросил (заполнил форму)

[Яндекс.Форма](https://forms.yandex-team.ru/surveys/25964/ "Форма для запроса отчета")

## Обновление процессов

Если не менялась связь между кубиками в графах Нирваны, то для обновления процессов достаточно изменить параметр "arcadia_revision" у соответствующего графа.
Если связи между блоками менялись, то необходимо изменить шаблон графа, на который ссылается процесс в Хитмане.
Если изменился сам шаблон, то необходимо обновить ссылку в Хитман процессе.

## Мониторинги

Для отслеживания ошибок в процессе настроено несколько мониторингов:
1) Нет упавших графов (e-mail, sms)
2) Мало средств в Толоке (e-mail)

[Мониторинги в Хитмане](https://hitman.yandex-team.ru/projects/domovoi/?_tab=monitorings "Мониторинги в Хитмане")

Что делать с сработавшими мониторингами:
1) Исправить причину падения
2) Перевести ошибку в статус "Уже исправлено"

Если не исправить ошибку, то новые процессы с детектированием запускаться не будут.
