#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import argparse


def get_blds_num(json_path):
    with open(json_path, "r") as f:
        return len(json.load(f))


def get_mds_url(json_path):
    with open(json_path, "r") as f:
        return json.load(f)[0]["downloadUrl"]


def create_comment(args):
    # extract values from json
    accepted_blds_number = get_blds_num(args.accepted_blds)
    accepted_blds_viewer = get_mds_url(args.accepted_viewer)
    rejected_blds_number = get_blds_num(args.rejected_blds)
    rejected_blds_viewer = get_mds_url(args.rejected_viewer)
    # create text
    text = "Публикация зданий на карту завершена.\n\n"
    text = text + "Результаты публикации:\n"
    text = text + "* Количество **!!(зел)опубликованных!!** зданий: {} ((({} Посмотреть))).\n".format(accepted_blds_number, accepted_blds_viewer)
    text = text + "* Количество **!!неопубликованных!!** зданий: {} ((({} Посмотреть))).\n".format(rejected_blds_number, rejected_blds_viewer)
    return text


def main():
    parser = argparse.ArgumentParser("Create publication results comment")
    parser.add_argument("--accepted_blds", required=True)
    parser.add_argument("--accepted_viewer", required=True)
    parser.add_argument("--rejected_blds", required=True)
    parser.add_argument("--rejected_viewer", required=True)
    parser.add_argument("--output", required=True)
    args = parser.parse_args()

    with open(args.output, "w") as f:
        f.write(create_comment(args))


if __name__ == "__main__":
    main()
