#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import argparse
import datetime


def get_blds_count(json_path):
    with open(json_path) as f:
        return len(json.load(f))


def get_mds_url(json_path):
    with open(json_path) as f:
        return json.load(f)[0]["downloadUrl"]


def main():
    parser = argparse.ArgumentParser("Create ST issue")
    parser.add_argument("--region", required=True)
    parser.add_argument("--region_id", required=True)
    parser.add_argument("--use_tolokers", action="store_true")
    parser.add_argument("--use_assessors", action="store_true")
    parser.add_argument("--accepted_blds", required=True)
    parser.add_argument("--rejected_blds", required=True)
    parser.add_argument("--accepted_viewer", required=True)
    parser.add_argument("--rejected_viewer", required=True)
    parser.add_argument("--followers", required=True)
    parser.add_argument("--issue_json", required=True)
    args = parser.parse_args()

    now = datetime.datetime.now()
    date = "{:02d}.{:02d}.{}".format(now.day, now.month, now.year)
    followers = args.followers.split(",")
    summary = "Автоматически детектированные здания в регионе " + args.region + ". " + date
    description = "В регионе ((https://npro.maps.yandex.ru/#!/objects/" + args.region_id + " " + args.region + ")) были обнаружены новые здания.\n"
    description = description + "\n"
    description = description + "Результаты детектирования:\n"
    description = description + "* Автоматически принятые здания: {} ((({} Посмотреть)))\n".format(get_blds_count(args.accepted_blds), get_mds_url(args.accepted_viewer))
    description = description + "* Автоматически отклоненные здания: {} ((({} Посмотреть)))\n".format(get_blds_count(args.rejected_blds), get_mds_url(args.rejected_viewer))
    description = description + "\n"
    description = description + "Параметры валадиции\n"
    description = description + "* Валидировать толокерами: " + ("**!!(зел)Да!!**" if args.use_tolokers else "**!!Нет!!**") + "\n"
    description = description + "* Валидировать асессорами: " + ("**!!(зел)Да!!**" if args.use_assessors else "**!!Нет!!**") + "\n"
    description = description + "\n"
    issue = {
        "followers": followers,
        "summary": summary,
        "description": description,
        "tags": ["детектирование"]
    }

    with open(args.issue_json, "w") as f:
        json.dump(issue, f)


if __name__ == "__main__":
    main()
