#include <maps/libs/log8/include/log8.h>
#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/exception.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/yt_storage.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/config/include/config.h>

#include <mapreduce/yt/interface/client.h>

using namespace maps::wiki::autocart::pipeline;

int main(int argc, const char** argv)
try {
    NYT::Initialize(argc, argv);

    maps::cmdline::Parser parser("Update issue id");

    maps::cmdline::Option<std::string> ytConfigPath = parser.string("yt_config")
        .required()
        .help("Path to YT config");

    maps::cmdline::Option<std::string> region = parser.string("region")
        .required()
        .help("Region name from MPRO");

    maps::cmdline::Option<size_t> issueId = parser.size_t("issue_id")
        .required()
        .help("new issue id");

    parser.parse(argc, const_cast<char**>(argv));

    INFO() << "Connecting to yt::hahn";
    NYT::IClientPtr client = NYT::CreateClient("hahn");

    INFO() << "Loading YT config: " << ytConfigPath;
    YTConfig config(ytConfigPath);

    INFO() << "Connecting to YT storage: " << config.storagePath();
    YTStorageClient storage(client, config.storagePath());

    INFO() << "Updating issue id: " << issueId;
    storage.updateIssue(TString(region), issueId);

    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    INFO() << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    INFO() << e.what();
    return EXIT_FAILURE;
}
catch (...) {
    INFO() << "Caught unknown exception";
    return EXIT_FAILURE;
}
