#include <maps/libs/log8/include/log8.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/cmdline/include/cmdline.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/yt_storage.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/config/include/config.h>

#include <mapreduce/yt/interface/client.h>

using namespace maps::wiki::autocart::pipeline;

int main(int argc, const char** argv)
try {
    NYT::Initialize(argc, argv);

    maps::cmdline::Parser parser("Initialize process resources in YT");

    maps::cmdline::Option<std::string> ytConfigPath = parser.string("yt_config")
        .required()
        .help("Path to YT config");

    parser.parse(argc, const_cast<char**>(argv));

    INFO() << "Connecting to yt::hahn";
    NYT::IClientPtr client = NYT::CreateClient("hahn");

    INFO() << "Loading YT config: " << ytConfigPath;
    YTConfig config(ytConfigPath);

    NYT::ITransactionPtr txn = client->StartTransaction();

    INFO() << "Creating YT storage: " << config.storagePath();
    createYTStorage(txn, config.storagePath());

    txn->Commit();

    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    ERROR() << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    ERROR() << e.what();
    return EXIT_FAILURE;
}
catch (...) {
    ERROR() << "unknown error";
    return EXIT_FAILURE;
}
