#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/assessors/include/utils.h>

#include <maps/libs/shellcmd/include/yandex/maps/shell_cmd.h>

#include <regex>

namespace maps::wiki::autocart::pipeline {

namespace {

void zip(
    const std::string& zipPath,
    const std::vector<std::string>& paths,
    const std::string& options)
{
    std::string cmd = "zip " + options + " " + zipPath;
    for (const std::string& path : paths) {
        cmd += " " + path;
    }
    const maps::shell::Result result = maps::shell::runCmd(cmd);
    REQUIRE(result.exitCode == 0, result.stdErr);
}

} // namespace

bool isCorrectDate(const std::string& date) {
    return std::regex_match(
        std::string(date),
        std::regex("[0-9]{4}-[0-9]{2}-[0-9]{2}")
    );
}

chrono::TimePoint beginOfDay(const std::string& date) {
    return chrono::parseIsoDateTime(date + "T00:00:00.000");
}

chrono::TimePoint endOfDay(const std::string& date) {
    return chrono::parseIsoDateTime(date + "T23:59:59.999");
}

void zipFiles(const std::string& path, const std::vector<std::string>& filePaths) {
    zip(path, filePaths, "-j");
}

void zipDirectories(const std::string& path, const std::vector<std::string>& dirPaths) {
    zip(path, dirPaths, "-r");
}

std::string strip(const std::string& str, const std::string& tails) {
    const size_t begin = str.find_first_not_of(tails);
    if (begin == std::string::npos)
        return ""; // no content
    const size_t end = str.find_last_not_of(tails);
    const size_t length = end - begin + 1;
    return str.substr(begin, length);
}

} // namespace maps::wiki::autocart::pipeline
