#pragma once

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/wiki/include/table.h>

#include <map>
#include <string>
#include <vector>

#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

struct Assessor {
    static Assessor fromYTNode(const NYT::TNode& node);
    static Assessor fromWikiTableRow(const WikiTableRow& row);

    NYT::TNode toYTNode() const;

    bool operator<(const Assessor& that) const;
    bool operator==(const Assessor& that) const;

    std::string id;
    std::string login;
    std::string company;
};

// see https://auth.yandex-team.ru for OAuth token
// table name example:
//     URL - https://wiki.yandex-team.ru/users/dolotov-e/Arkadija/
//     name - users/dolotov-e/Arkadija
std::vector<Assessor> loadAssessorsFromWikiTable(
    const std::string& tableName, const std::string& oauthToken);

// see https://auth.yandex-team.ru for OAuth token
// table name example:
//     URL - https://wiki.yandex-team.ru/users/dolotov-e/Arkadija/
//     name - users/dolotov-e/Arkadija
std::map<std::string, std::string> loadLoginByWorkerIdFromWikiTable(
    const std::string& tableName, const std::string& oauthToken);

std::vector<Assessor> loadAssessorsFromYTTable(
    NYT::IClientBasePtr client, const TString& tableName);

} // namespace maps::wiki::autocart::pipeline
