#pragma once

#include <maps/libs/chrono/include/time_point.h>

#include <string>
#include <vector>

namespace maps::wiki::autocart::pipeline {

bool isCorrectDate(const std::string& date);

chrono::TimePoint beginOfDay(const std::string& date);
chrono::TimePoint endOfDay(const std::string& date);

void zipFiles(const std::string& path, const std::vector<std::string>& filePaths);

void zipDirectories(const std::string& path, const std::vector<std::string>& dirPaths);

std::string strip(const std::string& str, const std::string& tails = " \t\n\r");

} // namespace maps::wiki::autocart::pipeline
