#pragma once

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/tolokers_results.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/assessors_results.h>

#include <maps/libs/json/include/value.h>

namespace maps::wiki::autocart::pipeline {

struct Assignment {
    static Assignment deserializeFromJson(const json::Value& value);

    uint64_t resultId;
    Building bld;
    TolokaState state;
    std::string userId;
    std::string taskId;
};


// Aggregate results from tolokers
// Aggregate results according to majority.
// If majority answer does not exists, then answer is "unknown"
//
// Example of input json:
// [
//  {
//   "inputValues" : {"polygon" : [[1., 1.], [0., 0.], [2., 3.]]},
//   "taskId" : "task-1", "userId" : "user-1",
//   "outputValues" : {"state" : "yes"}
//  },
//  {
//   "inputValues" : {"polygon" : [[5., 6.], [4., 0.], [6., 4.]]},
//   "taskId" : "task-2", "userId" : "user-2",
//   "outputValues" : {"state" : "no"}
//  }
// ]
//
std::vector<TolokersResult>
aggregateTolokersAssignments(const json::Value& assignmentsJson);

// Aggregate results from assessors
// Each task must have unique answer
//
// Example of input json:
// [
//  {
//   "inputValues" : {"polygon" : [[1., 1.], [0., 0.], [2., 3.]]},
//   "taskId" : "task-1", "userId" : "user-1"
//   "outputValues" : {"state" : "yes", "ft_type_id" : "101", "height" : "6"}
//  },
//  {
//   "inputValues" : {"polygon" : [[5., 6.], [4., 0.], [6., 4.]]},
//   "taskId" : "task-2", "userId" : "user-2"
//   "outputValues" : {"state" : "no", "ft_type_id" : "", "height" : ""}
//  }
// ]
//
std::vector<AssessorsResult>
aggregateAssessorsAssignments(
    const json::Value& assignmentsJson,
    const std::map<std::string, std::string>& loginByWorkerId);

} // namespace maps::wiki::autocart::pipeline
