#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/config/include/strings.h>

#include <maps/libs/json/include/value.h>

#include <string>

namespace maps::wiki::autocart::pipeline {

DetectorConfig::DetectorConfig(const json::Value& value) {
    dwellplacesYTFolder_ = value[FIELD_DWELLPLACES_YT_FOLDER].as<std::string>();
    cellSizeMercator_ = value[FIELD_CELL_SIZE_MERCATOR].as<double>();
    padSizeMercator_ = value[FIELD_PAD_SIZE_MERCATOR].as<double>();
    dwellplaceDistanceMeters_ = value[FIELD_DWELLPLACE_DISTANCE_METERS].as<double>();
    mode_ = value[FIELD_MODE].as<std::string>();
    zoom_ = value[FIELD_ZOOM].as<size_t>();
    jobSize_ = value[FIELD_JOB_SIZE].as<size_t>();
    runningJobCount_ = value[FIELD_RUNNING_JOB_COUNT].as<size_t>();
    tileSourceURL_ = value[FIELD_TILE_SOURCE_URL].as<std::string>();
    rejectedIOUThreshold_ = value[FIELD_REJECTED_IOU_THRESHOLD].as<double>();
}

DetectorConfig::DetectorConfig(const std::string& configPath)
    : DetectorConfig(json::Value::fromFile(configPath))
{}

TString DetectorConfig::dwellplacesYTFolder() const {return dwellplacesYTFolder_; };

double DetectorConfig::cellSizeMercator() const {return cellSizeMercator_; }

double DetectorConfig::padSizeMercator() const { return padSizeMercator_; }

double DetectorConfig::dwellplaceDistanceMeters() const { return dwellplaceDistanceMeters_; }

const TString& DetectorConfig::mode() const { return mode_; }

size_t DetectorConfig::zoom() const { return zoom_; }

size_t DetectorConfig::jobSize() const { return jobSize_; }

size_t DetectorConfig::runningJobCount() const { return runningJobCount_; }

TString DetectorConfig::tileSourceURL() const { return tileSourceURL_; }

double DetectorConfig::rejectedIOUThreshold() const { return rejectedIOUThreshold_; }


AutoTolokerConfig::AutoTolokerConfig(const json::Value& value) {
    threshold_ = value[FIELD_THRESHOLD].as<double>();
    zoom_ = value[FIELD_ZOOM].as<size_t>();
    padRatio_ = value[FIELD_PAD_RATIO].as<double>();
    jobSize_ = value[FIELD_JOB_SIZE].as<size_t>();
    runningJobCount_ = value[FIELD_RUNNING_JOB_COUNT].as<size_t>();
    tileSourceURL_ = value[FIELD_TILE_SOURCE_URL].as<std::string>();
}

AutoTolokerConfig::AutoTolokerConfig(const std::string& configPath)
    : AutoTolokerConfig(json::Value::fromFile(configPath))
{}

double AutoTolokerConfig::threshold() const { return threshold_; }

size_t AutoTolokerConfig::zoom() const { return zoom_; }

double AutoTolokerConfig::padRatio() const { return padRatio_; }

size_t AutoTolokerConfig::jobSize() const { return jobSize_; }

size_t AutoTolokerConfig::runningJobCount() const { return runningJobCount_; }

const TString& AutoTolokerConfig::tileSourceURL() const { return tileSourceURL_; }


TolokersConfig::TolokersConfig(const json::Value& value) {
    const json::Value& mixerConfig = value[FIELD_MIXER_CONFIG];

    minGoldenTasksCount_ = mixerConfig[FIELD_MIN_GOLDEN_TASKS_COUNT].as<size_t>();
    goldenTasksCount_ = mixerConfig[FIELD_GOLDEN_TASKS_COUNT].as<size_t>();
    minRealTasksCount_ = mixerConfig[FIELD_MIN_REAL_TASKS_COUNT].as<size_t>();
    realTasksCount_ = mixerConfig[FIELD_REAL_TASKS_COUNT].as<size_t>();
    rewardPerAssignment_ = value[FIELD_REWARD_PER_ASSIGNMENT].as<double>();
}

TolokersConfig::TolokersConfig(const std::string& configPath)
    : TolokersConfig(json::Value::fromFile(configPath))
{}

size_t TolokersConfig::minGoldenTasksCount() const { return minGoldenTasksCount_; }

size_t TolokersConfig::goldenTasksCount() const { return goldenTasksCount_; }

size_t TolokersConfig::minRealTasksCount() const { return minRealTasksCount_; }

size_t TolokersConfig::realTasksCount() const { return realTasksCount_; }

double TolokersConfig::rewardPerAssignment() const { return rewardPerAssignment_; }


AssessorsConfig::AssessorsConfig(const json::Value& value) {
    rewardPerTask_ = value[FIELD_REWARD_PER_TASK].as<double>();
    tasksCount_ = value[FIELD_TASKS_COUNT].as<size_t>();
    goldenSuitesFrequency_ = value[FIELD_GOLDEN_SUITES_FREQUENCY].as<size_t>();
    goldenTasksCount_ = value[FIELD_GOLDEN_TASKS_COUNT].as<size_t>();
}

AssessorsConfig::AssessorsConfig(const std::string& configPath)
    : AssessorsConfig(json::Value::fromFile(configPath))
{}

double AssessorsConfig::rewardPerTask() const { return rewardPerTask_; }

size_t AssessorsConfig::tasksCount() const { return tasksCount_; }

size_t AssessorsConfig::goldenSuitesFrequency() const { return goldenSuitesFrequency_; }

size_t AssessorsConfig::goldenTasksCount() const { return goldenTasksCount_; }


YTConfig::YTConfig(const json::Value& value) {
    statePath_ = value[FIELD_STATE_PATH].as<std::string>();
    storagePath_ = value[FIELD_STORAGE_PATH].as<std::string>();
}

YTConfig::YTConfig(const std::string& configPath)
    : YTConfig(json::Value::fromFile(configPath))
{}

TString YTConfig::statePath() const { return statePath_; }
TString YTConfig::storagePath() const { return storagePath_; }

} // maps::wiki::autocart::pipeline
