#pragma once

#include <maps/libs/json/include/value.h>

#include <util/generic/string.h>

namespace maps::wiki::autocart::pipeline {

class DetectorConfig {
public:
    DetectorConfig(const json::Value& value);
    DetectorConfig(const std::string& configPath);

    TString dwellplacesYTFolder() const;

    double cellSizeMercator() const;

    double padSizeMercator() const;

    double dwellplaceDistanceMeters() const;

    const TString& mode() const;

    size_t zoom() const;

    size_t jobSize() const;

    size_t runningJobCount() const;

    TString tileSourceURL() const;

    double rejectedIOUThreshold() const;

private:
    TString dwellplacesYTFolder_;
    double cellSizeMercator_;
    double padSizeMercator_;
    double dwellplaceDistanceMeters_;
    TString mode_;
    size_t zoom_;
    size_t jobSize_;
    size_t runningJobCount_;
    TString tileSourceURL_;
    double rejectedIOUThreshold_;
};

class AutoTolokerConfig {
public:
    AutoTolokerConfig(const json::Value& value);
    AutoTolokerConfig(const std::string& configPath);

    double threshold() const;

    size_t zoom() const;

    double padRatio() const;

    size_t jobSize() const;

    size_t runningJobCount() const;

    const TString& tileSourceURL() const;

private:
    double threshold_;
    size_t zoom_;
    double padRatio_;
    size_t jobSize_;
    size_t runningJobCount_;
    TString tileSourceURL_;
};

class TolokersConfig {
public:
    TolokersConfig(const json::Value& value);
    TolokersConfig(const std::string& configPath);

    size_t minGoldenTasksCount() const;

    size_t goldenTasksCount() const;

    size_t minRealTasksCount() const;

    size_t realTasksCount() const;

    double rewardPerAssignment() const;

private:
    size_t minGoldenTasksCount_;
    size_t goldenTasksCount_;
    size_t minRealTasksCount_;
    size_t realTasksCount_;
    double rewardPerAssignment_;
};

class AssessorsConfig {
public:
    AssessorsConfig(const json::Value& value);
    AssessorsConfig(const std::string& configPath);

    double rewardPerTask() const;

    size_t tasksCount() const;

    size_t goldenSuitesFrequency() const;

    // number of golden tasks in golden suite
    size_t goldenTasksCount() const;

private:
    double rewardPerTask_;
    size_t tasksCount_;
    size_t goldenSuitesFrequency_;
    size_t goldenTasksCount_;
};

class YTConfig {
public:
    YTConfig(const json::Value& value);
    YTConfig(const std::string& configPath);

    TString statePath() const;
    TString storagePath() const;

private:
    TString statePath_;
    TString storagePath_;
};

} // maps::wiki::autocart::pipeline
