#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/detection/include/execution.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::autocart::pipeline {

namespace {

static const std::chrono::hours UPDATE_TIMEOUT_HOURS(2 * 24); // 2 days

} // namespace

void removeUptodateRegions(
    BldRecognitionRegions& regions,
    const Release& lastRelease,
    const std::unordered_map<TString, ProcessedIssue>& regionToIssue,
    const chrono::TimePoint& dumpDate)
{
    for (int i = static_cast<int>(regions.size() - 1); i >= 0; i--) {
        auto it = regionToIssue.find(TString(regions[i].name()));
        if (it == regionToIssue.end()) {
            INFO() << regions[i].name() << " is new region";
        } else {
            const auto& [issueId, date] = it->second;
            if (issueId < lastRelease.issueId) {
                if (dumpDate < date + UPDATE_TIMEOUT_HOURS) {
                    INFO() << "There is no YT dump that was created more than "
                           << UPDATE_TIMEOUT_HOURS.count() << " hours after "
                           << "last execution for region " << regions[i].name();
                    regions.erase(regions.begin() + i);
                } else {
                    INFO() << "Region " << regions[i].name() << " is outdated."
                       << " Last processed issue " << it->second.issueId;
                }
            } else {
                INFO() << "Region " << regions[i].name() << " is up to date";
                regions.erase(regions.begin() + i);
            }
        }
    }
}

} // namespace maps::wiki::autocart::pipeline
