#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/detection/include/extract_unique_rows.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/detection/include/state.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/yt_utils/include/op_wrapper.h>

#include <mapreduce/yt/util/temp_table.h>
#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

namespace {

class ExtractUniqueRowsReducer
    : public NYT::IReducer<NYT::TTableReader<NYT::TNode>,
                           NYT::TTableWriter<NYT::TNode>> {
public:
    void Do(NYT::TTableReader<NYT::TNode>* reader,
            NYT::TTableWriter<NYT::TNode>* writer) override {
        if (reader->IsValid()) {
            const NYT::TNode& row = reader->GetRow();
            writer->AddRow(row);
        }
    }
};

REGISTER_REDUCER(ExtractUniqueRowsReducer);

} // namespace

void extractUniqueRows(
    NYT::IClientBasePtr client,
    const std::vector<TString>& inputYTTableNames,
    const TString& outputYTTableName,
    const NYT::TSortColumns& columns)
{
    NYT::TTempTable tmpTable = State::getTempTable(client);
    NYT::TSortOperationSpec sortSpec;
    for (const TString& inputYTTableName : inputYTTableNames) {
        sortSpec.AddInput(inputYTTableName);
    }
    sortSpec.Output(tmpTable.Name());
    sortSpec.SortBy(columns);
    client->Sort(sortSpec);
    YTOpExecutor::Reduce(
        client,
        YTOpExecutor::ReduceSpec()
            .AddInput(tmpTable.Name())
            .AddOutput(outputYTTableName)
            .ReduceBy(columns),
        new ExtractUniqueRowsReducer(),
        YTOpExecutor::Options()
            .Title("[Buildings detector] Extracting unique rows")
    );
}

} // namespace maps::wiki::autocart::pipeline
