#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/detection/include/state.h>

#include <maps/libs/common/include/exception.h>

#include <mapreduce/yt/util/ypath_join.h>
#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

TString State::path_ = "";
TString State::tmpPath_ = "";


void State::initialize(NYT::IClientPtr client, const TString& path) {
    REQUIRE(path_.empty(), "Path to state has already been set");
    path_ = path;
    tmpPath_ = NYT::JoinYPaths(path_, "tmp");
    if (!client->Exists(tmpPath_)) {
        client->Create(
            tmpPath_, NYT::NT_MAP,
            NYT::TCreateOptions()
                .Recursive(true)
                .IgnoreExisting(false)
        );
    }
}


TString State::tablePath(const TString& tableName) {
    REQUIRE(!path_.empty(), "Path has not yet been set");
    return NYT::JoinYPaths(path_, tableName);
}

TString State::regionsTablePath() {
    return tablePath("regions");
}

TString State::areasTablePath() {
    return tablePath("areas");
}

TString State::roadsTablePath() {
    return tablePath("roads");
}

TString State::buildingsTablePath() {
    return tablePath("blds");
}

TString State::dwellplacesTablePath() {
    return tablePath("dwellplaces");
}

TString State::cellsTablePath() {
    return tablePath("cells");
}

TString State::detectionTablePath() {
    return tablePath("detection");
}

TString State::validationTablePath() {
    return tablePath("validation");
}

TString State::notRejectedTablePath() {
    return tablePath("not_rejected");
}


NYT::TTempTable State::getTempTable(NYT::IClientBasePtr client) {
    REQUIRE(!path_.empty(), "Path has not yet been set");
    static const TString EMPTY_PREFIX = "";
    return NYT::TTempTable(client, EMPTY_PREFIX, tmpPath_);
}


void State::remove(NYT::IClientPtr client) {
    client->Remove(path_, NYT::TRemoveOptions().Recursive(true).Force(true));
    path_.clear();
    tmpPath_.clear();
}

} // namespace maps::wiki::autocart::pipeline
