#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/detection/include/ymapsdf.h>

#include <mapreduce/yt/util/ypath_join.h>
#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

namespace {

std::vector<TString> getAllRegionsYTTablePaths(
    NYT::IClientBasePtr client, const TString& tableName)
{
    std::vector<TString> tablePaths;
    NYT::TNode::TListType regionList = client->List(LATEST_YMAPSDF_PATH);
    for (int i = 0; i < regionList.ysize(); i++) {
        TString region = regionList[i].AsString();
        tablePaths.push_back(
            NYT::JoinYPaths(LATEST_YMAPSDF_PATH, region, tableName)
        );
    }
    return tablePaths;
}

} // namespace

chrono::TimePoint YMapsDFYTTable::getDate(NYT::IClientBasePtr client) {
    return chrono::parseIsoDateTime(
        client->Get(LATEST_YMAPSDF_PATH + "/@modification_time").AsString()
    );
}

std::vector<TString> YMapsDFYTTable::getRoadsYTTablePaths(NYT::IClientBasePtr client) {
    static const TString RD_EL_TABLE_NAME = "rd_el";
    return getAllRegionsYTTablePaths(client, RD_EL_TABLE_NAME);
}

std::vector<TString> YMapsDFYTTable::getBuildingsYTTablePaths(NYT::IClientBasePtr client) {
    static const TString BLD_GEOM_TABLE_NAME = "bld_geom";
    return getAllRegionsYTTablePaths(client, BLD_GEOM_TABLE_NAME);
}

std::vector<TString> YMapsDFYTTable::getFTYTTablePaths(NYT::IClientBasePtr client) {
    static const TString FT_TABLE_NAME = "ft";
    return getAllRegionsYTTablePaths(client, FT_TABLE_NAME);
}

std::vector<TString> YMapsDFYTTable::getFTGeomYTTablePaths(NYT::IClientBasePtr client) {
    static const TString FT_GEOM_TABLE_NAME = "ft_geom";
    return getAllRegionsYTTablePaths(client, FT_GEOM_TABLE_NAME);
}

} // namespace maps::wiki::autocart::pipeline
