#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/json/include/builder.h>

#include <mapreduce/yt/interface/client.h>

#include <unordered_map>

namespace maps::wiki::autocart::pipeline {

const int NULL_HEIGHT = -1;

struct Change {
    uint64_t bldId;
    bool isDeleted;
    bool isGeomChanged;
    // gt and test
    std::optional<std::pair<FTTypeId, FTTypeId>> ftTypeIdChange;
    // gt and test
    std::optional<std::pair<int, int>> heightChange;
};

void changeToJson(const Change& change, json::ObjectBuilder& builder);

std::vector<Change> compareBuildings(
    NYT::IClientBasePtr client,
    const TString& gtTablePath,
    const TString& testTablePath,
    double iou);

} // namespace maps::wiki::autocart::pipeline
