#pragma once

#include <maps/libs/geolib/include/multipolygon.h>

#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

void createCellsWithObjectsByDwellplaces(
    NYT::IClientBasePtr client,
    const TString& bldsYTTablePath,
    const TString& roadsYTTablePath,
    const TString& areasYTTablePath,
    const TString& dwellplacesYTTablePath,
    double cellSizeInMercator,
    double padSizeInMercator,
    const TString& outputYTTablePath);

void createCellsWithObjectsByRegions(
    NYT::IClientBasePtr client,
    const TString& bldsYTTablePath,
    const TString& roadsYTTablePath,
    const TString& areasYTTablePath,
    const geolib3::MultiPolygon2& mercRegions,
    double cellSizeInMercator,
    double padSizeInMercator,
    const TString& outputYTTablePath);

} // namespace maps::wiki::autocart::pipeline
