#pragma once

#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

// Update dwellplaces that are used in detection tasks
// Tables with dwellplaces are stored in $DOMOVOI_YT_PATH/dwellplaces
// $DOMOVOI_YT_PATH/dwellplaces/current is simlink to the latest table
// All tables have same format of name: <year>-<month>-<day>
//  Example of name: 2019-06-17
// Each dwellplace in table is unique. This means that there are no other
// points that are closer than specified distance.
// After updating old tables will be deleted if they are not used
// in any operations
// @param ytClient - YT client
// @param dwellplacesFolderYTPath - path to folder with all dwellplaces:
//     Example: //home/user_identification/orgvisits/prod/state/dwellplaces/current
// @param duplicateDistanceInMeters - minimal distance between unique dwellplaces
void extractUniqueDwellplaces(
    NYT::IClientBasePtr client,
    const TString& dwellplacesYTFolderName,
    const TString& outputYTTableName,
    double duplicateDistanceInMercator);

} // namespace maps::wiki::autocart::pipeline
