#pragma once

#include <maps/libs/geolib/include/multipolygon.h>

#include <mapreduce/yt/interface/client.h>

#include <vector>

namespace maps::wiki::autocart::pipeline {

template <class Object>
void filterByRegions(
    NYT::IClientBasePtr client,
    const std::vector<TString>& inputYTTableNames,
    const geolib3::MultiPolygon2& regions,
    const TString& outputYTTableName);

template <class Object>
void extractByRegions(
    NYT::IClientBasePtr client,
    const TString& inputYTTableName,
    const geolib3::MultiPolygon2& regions,
    const TString& outputYTTableName);

} // namespace maps::wiki::autocart::pipeline
