#pragma once

#include <mapreduce/yt/util/temp_table.h>
#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

class State {
public:
    static void initialize(NYT::IClientPtr client, const TString& path);

    static TString regionsTablePath();

    static TString areasTablePath();

    static TString roadsTablePath();

    static TString buildingsTablePath();

    static TString dwellplacesTablePath();

    static TString cellsTablePath();

    static TString detectionTablePath();

    static TString validationTablePath();

    static TString notRejectedTablePath();

    static NYT::TTempTable getTempTable(NYT::IClientBasePtr client);

    static void remove(NYT::IClientPtr client);

private:
    static TString tablePath(const TString& tableName);

    static TString path_;
    static TString tmpPath_;
};

} // namespace maps::wiki::autocart::pipeline
