LIBRARY()

OWNER(dolotov-e)

PEERDIR(
    maps/libs/log8
    maps/libs/json
    maps/libs/geolib
    maps/libs/chrono
    maps/libs/cmdline
    mapreduce/yt/util
    mapreduce/yt/interface
    maps/libs/tile
    maps/wikimap/mapspro/services/autocart/libs/utils
    maps/wikimap/mapspro/services/autocart/libs/geometry
    maps/wikimap/mapspro/services/autocart/libs/satellite
    maps/wikimap/mapspro/services/autocart/libs/detection
    maps/wikimap/mapspro/services/autocart/libs/auto_toloker
    maps/wikimap/mapspro/services/autocart/libs/post_processing
    maps/libs/enum_io
    maps/wikimap/mapspro/libs/editor_client
    maps/wikimap/mapspro/services/autocart/pipeline/libs/hitman_client
    maps/wikimap/mapspro/services/autocart/pipeline/libs/objects
    maps/wikimap/mapspro/services/autocart/pipeline/libs/toloka
    maps/wikimap/mapspro/services/autocart/pipeline/libs/config
    maps/wikimap/mapspro/services/autocart/pipeline/libs/storage
    maps/wikimap/mapspro/services/autocart/pipeline/libs/yt_utils
    maps/wikimap/mapspro/services/autocart/pipeline/libs/mpro
)

SRCS(
    impl/state.cpp
    impl/ymapsdf.cpp
    impl/compare_blds.cpp
    impl/cover_by_cells.cpp
    impl/remove_rejected.cpp
    impl/filter_by_regions.cpp
    impl/extract_unique_rows.cpp
    impl/filter_by_ft_type_id.cpp
    impl/detect_blds_in_cells.cpp
    impl/inference_auto_toloker.cpp
    impl/create_cells_with_objects.cpp
    impl/filter_dwellplaces_by_blds.cpp
    impl/extract_unique_dwellplaces.cpp
    impl/execution.cpp
)

FROM_SANDBOX(
    879143487
    OUT_NOAUTO
    sem_segm.gdef
    edge_detection.gdef
    maskrcnn.gdef
)

RESOURCE(
    sem_segm.gdef /maps/autocart/dwellplaces/models/sem_segm.gdef
    edge_detection.gdef /maps/autocart/dwellplaces/models/edge_detection.gdef
    maskrcnn.gdef /maps/autocart/dwellplaces/models/maskrcnn.gdef
)

END()

RECURSE(
    tests
)
