#pragma once

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/mpro/include/region.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/hitman_client/include/client.h>

#include <set>
#include <string>

namespace maps::wiki::autocart::pipeline {

static const std::string DETECTION_PROCESS_CODE = "domovoi_detection";
static const std::string CREATE_ST_ISSUE_PROCESS_CODE = "domovoi_create_st_issue";
static const std::string LOAD_TOLOKERS_TASKS_PROCESS_CODE = "domovoi_load_tolokers_tasks";
static const std::string TOLOKERS_VALIDATION_PROCESS_CODE = "domovoi_tolokers_validation";
static const std::string LOAD_ASSESSORS_TASKS_PROCESS_CODE = "domovoi_load_assessors_tasks";
static const std::string ASSESSORS_VALIDATION_PROCESS_CODE = "domovoi_assessors_validation";
static const std::string PUBLICATION_REQUEST_PROCESS_CODE = "domovoi_nmaps_publication_request";
static const std::string PUBLICATION_PROCESS_CODE = "domovoi_nmaps_publication";


// Get id of all region names that used in some running Hitman jobs
// For this infomation this method makes two type of requests:
//  * Check jobs by statuss:
//      Get all Hitman jobs with following statuses:
//        NEW, RUNNING, RESUMING, IN_CANCELLATION
//  * Get job properties:
//      Get region property of Hitman job for all jobs,
//      received in previous step
std::set<std::string> loadRegionsInProcessing(const hitman::HitmanClient& client);

// Return true if there is jobs with status from list:
//   START_FAILED, FAILED
bool hasFailedJobs(const hitman::HitmanClient& client);

hitman::HitmanJobId runSTIssueProcess(
    const hitman::HitmanClient& client,
    uint64_t id, const std::string& region,
    bool useTolokers, bool useAssessors,
    uint64_t issueId);

hitman::HitmanJobId runProcess(
    const hitman::HitmanClient& client, const std::string processCode,
    const std::string& stIssue,
    const std::string& region,
    bool useTolokers, bool useAssessors,
    uint64_t issueId);

hitman::HitmanJobId runValidationProcess(
    const hitman::HitmanClient& client, const std::string processCode,
    const std::string& stIssue,
    const std::string& region,
    bool useTolokers, bool useAssessors,
    uint64_t issueId,
    const std::string& poolId);



} // namespace maps::wiki::autocart::pipeline
