#pragma once

#include <maps/libs/geolib/include/polygon.h>

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <pqxx/transaction_base>
#include <yandex/maps/wiki/revision/revisionsgateway.h>

#include <mapreduce/yt/interface/client.h>

#include <string>
#include <vector>

namespace maps::wiki::autocart::pipeline {

class BldRecognitionRegion {
public:
    BldRecognitionRegion() = default;
    BldRecognitionRegion(const revision::ObjectRevision& object);

    revision::RevisionID revisionId() const;
    const std::string& name() const;

    geolib3::Polygon2 toMercatorGeom() const;
    const geolib3::Polygon2& toGeodeticGeom() const;

    NYT::TNode toYTNode() const;
    void toYTNode(NYT::TNode& node) const;
    static BldRecognitionRegion fromYTNode(const NYT::TNode& node);

    bool useTolokers() const;
    bool useAssessors() const;
    bool useDwellplaces() const;
    bool isActive() const;

    bool operator==(const BldRecognitionRegion& that) const;

private:
    revision::RevisionID revisionId_;
    std::string name_;
    bool useTolokers_;
    bool useAssessors_;
    bool useDwellplaces_;
    bool isActive_;
    geolib3::Polygon2 geoGeom_;
};

using BldRecognitionRegions = std::vector<BldRecognitionRegion>;


BldRecognitionRegions loadAllBldRecognitionRegions(pqxx::transaction_base& txn);

BldRecognitionRegions
loadAllBldRecognitionRegions(const maps::wiki::common::ExtendedXmlDoc& mproConfig);

std::optional<BldRecognitionRegion>
loadBldRecognitionRegion(pqxx::transaction_base& txn, const std::string& name);

void removeInactiveRegions(BldRecognitionRegions& regions);

void removeUsedRegions(
    BldRecognitionRegions& regions,
    const std::set<std::string>& processingRegionNames);

} // namespace maps::wiki::autocart::pipeline
