#pragma once

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/base_results.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/publication_results.h>

#include <maps/wikimap/mapspro/libs/editor_client/include/instance.h>
#include <maps/wikimap/mapspro/libs/types/include/uid.h>

#include <maps/libs/chrono/include/time_point.h>

#include <vector>
#include <chrono>

namespace maps::wiki::autocart::pipeline {

class PublicationTimeRange {
public:
    PublicationTimeRange(int startHour, int endHour);

    static PublicationTimeRange allDay();

    bool checkIsInRange(const chrono::TimePoint& timePoint) const;

    std::chrono::minutes getMinutesToStart(const chrono::TimePoint& timePoint) const;

private:
    PublicationTimeRange() = default;

    static int getHours(const chrono::TimePoint& timePoint);
    static int getMinutes(const chrono::TimePoint& timePoint);

    int startHour_;
    int endHour_;
};

std::vector<PublicationResult> publishBuildingsToNMaps(
    const std::vector<BaseResult>& baseResults,
    editor_client::Instance& readerClient,
    editor_client::Instance& writerClient,
    types::TUid uid,
    const PublicationTimeRange& timeRange,
    const std::string& statePath, size_t stateStep);

} // namespace maps::wiki::autocart::pipeline
